<?php
require_once $_SERVER['DOCUMENT_ROOT'].'/includes/auth.php';
require_once $_SERVER['DOCUMENT_ROOT'].'/db/db.php';

if ($_SESSION['role'] !== 'retailor') {
    header("Location: /dashboard.php");
    exit();
}
?>
<!DOCTYPE html>
<html>
<head>
<title>Solitech Payout</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body{background:#f4f6f9;}
.compact-card{font-size:14px;}
.compact-card .card-body{padding:12px;}
.compact-card input{height:34px;font-size:13px;}
.compact-card button{font-size:13px;padding:5px 10px;}
#alertBox{
    position:fixed;
    top:80px;
    right:20px;
    z-index:9999;
    min-width:250px;
}
@media(max-width:768px){
    #alertBox{
        right:10px;
        left:10px;
    }
}
</style>
</head>

<body>

<nav class="navbar navbar-light bg-white shadow-sm">
<div class="container-fluid">
<span class="navbar-brand">Solitech Payout</span>
<a href="/dashboard.php" class="btn btn-sm btn-secondary">Back</a>
</div>
</nav>

<div class="container-fluid mt-3">

<div id="alertBox"></div>

<div class="row g-2">

<!-- TOKEN -->
<div class="col-md-4">
<div class="card shadow compact-card">
<div class="card-header bg-dark text-white text-center">Token</div>
<div class="card-body text-center">
<button class="btn btn-primary btn-sm me-2" onclick="processToken('generate')">
Generate
</button>

</div>
</div>
</div>

<!-- REMITTER -->
<div class="col-md-4">
<div class="card shadow compact-card">
<div class="card-header bg-info text-white text-center">Remitter Login</div>
<div class="card-body">
<form id="remitterForm">
<div class="input-group">
<input type="text" name="mobile" class="form-control" placeholder="Mobile Number" required>
<button class="btn btn-primary btn-sm">Login</button>
</div>
</form>
</div>
</div>
</div>

<!-- ADD BENEFICIARY -->
<div class="col-md-4">
<div class="card shadow compact-card">
<div class="card-header bg-success text-white text-center">Add Beneficiary</div>
<div class="card-body">
<form id="addBeneForm">
<input type="text" name="RemitterNumber" class="form-control mb-1" placeholder="Remitter" required>
<input type="text" name="BeneName" class="form-control mb-1" placeholder="Name" required>
<input type="text" name="BeneAccount" class="form-control mb-1" placeholder="Account" required>
<input type="text" name="BeneIFSC" class="form-control mb-1" placeholder="IFSC" required>
<button class="btn btn-success btn-sm w-100">Add</button>
</form>
</div>
</div>
</div>

<!-- VERIFY BENEFICIARY -->
<div class="col-md-6">
<div class="card shadow compact-card">
<div class="card-header bg-warning text-center">Verify Beneficiary</div>
<div class="card-body">
<form id="verifyBeneForm">
<input type="text" name="beneficiary_id" class="form-control mb-2" placeholder="Beneficiary ID" required>
<button class="btn btn-warning btn-sm w-100">Verify</button>
</form>
</div>
</div>
</div>

<!-- PAYOUT -->
<div class="col-md-6">
<div class="card shadow compact-card">
<div class="card-header bg-danger text-white text-center">Payout</div>
<div class="card-body">
<form id="payoutForm">
<input type="text" name="beneficiary_id" class="form-control mb-1" placeholder="Beneficiary ID" required>
<input type="number" name="amount" class="form-control mb-2" placeholder="Amount" required>
<button class="btn btn-danger btn-sm w-100">Send</button>
</form>
</div>
</div>
</div>

</div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

<script>
function showAlert(msg,type='success'){
    const box=document.getElementById('alertBox');
    box.innerHTML=`
        <div class="alert alert-${type} shadow">
            ${msg}
        </div>
    `;
    setTimeout(()=>{ box.innerHTML=''; },2000);
}

/* TOKEN */
function processToken(type){
fetch('process_solitech_token.php',{
method:'POST',
headers:{'Content-Type':'application/x-www-form-urlencoded'},
body:'action='+type
})
.then(response=>{
    if(!response.ok) throw new Error("Server error");
    return response.json();
})
.then(data=>{
    showAlert(data.message, data.success?'success':'danger');
})
.catch(()=>{
    showAlert("Token process failed",'danger');
});
}

/* REMITTER */
document.getElementById('remitterForm').addEventListener('submit',function(e){
e.preventDefault();
fetch('process_remitter_login.php',{
method:'POST',
body:new FormData(this)
})
.then(response=>{
    if(!response.ok) throw new Error("Server error");
    return response.json();
})
.then(data=>{
    showAlert(data.message, data.success?'success':'danger');
})
.catch(()=>{
    showAlert("Remitter login failed",'danger');
});
});

/* ADD BENEFICIARY */
document.getElementById('addBeneForm').addEventListener('submit',function(e){
e.preventDefault();
fetch('process_add_beneficiary.php',{
method:'POST',
body:new FormData(this)
})
.then(r=>r.json())
.then(d=>showAlert(d.message,d.success?'success':'danger'))
.catch(()=>showAlert("Add beneficiary failed",'danger'));
});

/* VERIFY BENEFICIARY */
document.getElementById('verifyBeneForm').addEventListener('submit',function(e){
e.preventDefault();
fetch('process_verify_beneficiary.php',{
method:'POST',
body:new FormData(this)
})
.then(r=>r.json())
.then(d=>showAlert(d.message,d.success?'success':'danger'))
.catch(()=>showAlert("Verification failed",'danger'));
});

/* PAYOUT */
document.getElementById('payoutForm').addEventListener('submit',function(e){
e.preventDefault();
fetch('process_payout.php',{
method:'POST',
body:new FormData(this)
})
.then(r=>r.json())
.then(d=>showAlert(d.message,d.success?'success':'danger'))
.catch(()=>showAlert("Payout failed",'danger'));
});
</script>

</body>
</html>