<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once '../../includes/auth.php';
require_once '../../db/db.php';

header('Content-Type: application/json');

$config = require $_SERVER['DOCUMENT_ROOT'] . '/config/solitech_config.php';

if($_SESSION['role'] !== 'retailor'){
    echo json_encode(["success"=>false,"message"=>"Unauthorized"]);
    exit();
}

if($_SERVER['REQUEST_METHOD'] !== 'POST'){
    echo json_encode(["success"=>false,"message"=>"Invalid request"]);
    exit();
}

$user_id = $_SESSION['user_id'];

/* =========================
   LOAD CONFIG
========================= */
$mode = $config['mode'];
$solitech = $config[$mode];

$BASE_URL      = rtrim($solitech['base_url'], '/') . '/api/';
$CLIENT_ID     = $solitech['client_id'];
$CLIENT_SECRET = $solitech['client_secret'];
$CLIENT_PASS   = $solitech['client_pass'];
$CLIENT_PIN    = $solitech['client_pin'];

/* =========================
   VALIDATE INPUT
========================= */
$remitter = trim($_POST['RemitterNumber'] ?? '');
$beneName = trim($_POST['BeneName'] ?? '');
$beneAcc  = trim($_POST['BeneAccount'] ?? '');
$beneIfsc = trim($_POST['BeneIFSC'] ?? '');
$bankCode = trim($_POST['BankCode'] ?? '');
$pincode  = trim($_POST['BenePincode'] ?? '');

if($remitter=='' || $beneName=='' || $beneAcc=='' || $beneIfsc==''){
    echo json_encode(["success"=>false,"message"=>"Missing required fields"]);
    exit();
}

/* =========================
   CHECK DUPLICATE
========================= */
$check = mysqli_query($conn,"
SELECT id FROM solitech_beneficiaries 
WHERE user_id='$user_id'
AND bene_account='".mysqli_real_escape_string($conn,$beneAcc)."'
AND bene_ifsc='".mysqli_real_escape_string($conn,$beneIfsc)."'
LIMIT 1
");

if(mysqli_num_rows($check) > 0){
    echo json_encode([
        "success"=>false,
        "message"=>"Beneficiary already exists for this account & IFSC"
    ]);
    exit();
}

/* =========================
   GET TOKEN
========================= */
$token_q = mysqli_query($conn,"
SELECT access_token 
FROM solitech_tokens 
WHERE user_id='$user_id'
ORDER BY id DESC LIMIT 1
");

if(mysqli_num_rows($token_q)==0){
    echo json_encode(["success"=>false,"message"=>"Generate token first"]);
    exit();
}

$token_row = mysqli_fetch_assoc($token_q);
$access_token = $token_row['access_token'];

/* =========================
   CALL API
========================= */
$url = $BASE_URL . "Payout/APIUserPayoutAddBeneToList";

$payload = json_encode([
    "RemitterNumber" => $remitter,
    "BeneName"       => $beneName,
    "BeneAccount"    => $beneAcc,
    "BeneIfsc"       => $beneIfsc,
    "BankCode"       => $bankCode ?: null,
    "BenePincode"    => $pincode ?: null
]);

$headers = [
    "ClientId: $CLIENT_ID",
    "ClientSecret: $CLIENT_SECRET",
    "ClientPass: $CLIENT_PASS",
    "ClientPin: $CLIENT_PIN",
    "ClientToken: $access_token",
    "Content-Type: application/json"
];

$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => $payload,
    CURLOPT_HTTPHEADER => $headers,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_SSL_VERIFYPEER => false
]);

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);

if(curl_errno($ch)){
    echo json_encode([
        "success"=>false,
        "message"=>"API connection failed"
    ]);
    curl_close($ch);
    exit();
}

curl_close($ch);

$result = json_decode($response, true);

/* =========================
   SAVE IN DB
========================= */
$status = "Failed";
$bene_api_id = null;

if($http_code == 200 && isset($result['responseCode']) && $result['responseCode']==200){
    $status = "Success";
    $bene_api_id = $result['responseData'] ?? null;
}

$stmt = mysqli_prepare($conn,"
INSERT INTO solitech_beneficiaries
(user_id, remitter_mobile, bene_name, bene_account, bene_ifsc, bank_code, bene_pincode, bene_api_id, api_response, status)
VALUES (?,?,?,?,?,?,?,?,?,?)
");

mysqli_stmt_bind_param($stmt,"isssssssss",
    $user_id,
    $remitter,
    $beneName,
    $beneAcc,
    $beneIfsc,
    $bankCode,
    $pincode,
    $bene_api_id,
    $response,
    $status
);

mysqli_stmt_execute($stmt);

/* =========================
   RESPONSE
========================= */
if($status=="Success"){
    echo json_encode([
        "success"=>true,
        "message"=>"Beneficiary Added Successfully",
        "bene_id"=>$bene_api_id
    ]);
}else{
    $msg = $result['responseMessage'] ?? "Add beneficiary failed";
    echo json_encode([
        "success"=>false,
        "message"=>$msg
    ]);
}
exit;