<?php
require_once '../../includes/auth.php';
require_once '../../db/db.php';

$config = require $_SERVER['DOCUMENT_ROOT'] . '/config/solitech_config.php';
$mode = $config['mode'];
$cfg  = $config[$mode];

if($_SESSION['role'] !== 'retailor'){
    header("Location: ../../login.php");
    exit();
}

if($_SERVER['REQUEST_METHOD'] !== 'POST'){
    header("Location: payout_solitech.php");
    exit();
}

$bank_code = $_POST['bank_code'];

/* =========================
   GET TOKEN
========================= */
$token_query = mysqli_query($conn,"SELECT access_token FROM solitech_tokens ORDER BY id DESC LIMIT 1");

if(mysqli_num_rows($token_query) == 0){
    header("Location: payout_solitech.php?error=Generate token first");
    exit();
}

$token_row = mysqli_fetch_assoc($token_query);
$access_token = $token_row['access_token'];

/* =========================
   API CALL
========================= */

$url = $cfg['base_url'] . "/api/Payout/ApiUserGetMasterIFSCForBank";

$payload = json_encode([
    "BankCode" => $bank_code
]);

$headers = [
    "ClientId: ".$cfg['client_id'],
    "ClientSecret: ".$cfg['client_secret'],
    "ClientPass: ".$cfg['client_pass'],
    "ClientPin: ".$cfg['client_pin'],
    "ClientToken: ".$access_token,
    "Content-Type: application/json"
];

$ch = curl_init($url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

$result = json_decode($response, true);

if($http_code == 200 && isset($result['responseCode']) && $result['responseCode'] == 200){

    if(!empty($result['responseData'])){
        foreach($result['responseData'] as $ifsc){

            $ifsc_code = mysqli_real_escape_string($conn, $ifsc['IFSCCode']);
            $branch_name = mysqli_real_escape_string($conn, $ifsc['BranchName']);

            mysqli_query($conn,"
                INSERT INTO solitech_ifsc_master (bank_code, ifsc_code, branch_name)
                VALUES ('$bank_code','$ifsc_code','$branch_name')
                ON DUPLICATE KEY UPDATE branch_name='$branch_name'
            ");
        }
    }

    header("Location: payout_solitech.php?ifsc=updated");
    exit();

}else{
    header("Location: payout_solitech.php?error=ifsc_fetch_failed");
    exit();
}