<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once '../../includes/auth.php';
require_once '../../db/db.php';

header('Content-Type: application/json');

/* =========================
   LOAD CONFIG
========================= */
$config = require $_SERVER['DOCUMENT_ROOT'] . '/config/solitech_config.php';

$mode = $config['mode'];
$solitech = $config[$mode];

$BASE_URL      = rtrim($solitech['base_url'], '/') . '/api/';
$CLIENT_ID     = $solitech['client_id'];
$CLIENT_SECRET = $solitech['client_secret'];
$CLIENT_PASS   = $solitech['client_pass'];
$CLIENT_PIN    = $solitech['client_pin'];

if($_SESSION['role'] !== 'retailor'){
    echo json_encode(["success"=>false,"message"=>"Unauthorized"]);
    exit();
}

$retailor_id = $_SESSION['user_id'];

if($_SERVER['REQUEST_METHOD'] !== 'POST'){
    echo json_encode(["success"=>false,"message"=>"Invalid request"]);
    exit();
}

/* =========================
   VALIDATE INPUT
========================= */
if(empty($_POST['mobile'])){
    echo json_encode(["success"=>false,"message"=>"Mobile number required"]);
    exit();
}

$mobile = trim($_POST['mobile']);
$fname  = $_POST['fname'] ?? "Test";
$lname  = $_POST['lname'] ?? "User";

/* =========================
   GET TOKEN
========================= */
$token_query = mysqli_query($conn,"
SELECT access_token 
FROM solitech_tokens 
WHERE user_id='$retailor_id'
ORDER BY id DESC LIMIT 1
");

if(!$token_query || mysqli_num_rows($token_query) == 0){
    echo json_encode(["success"=>false,"message"=>"Generate token first"]);
    exit();
}

$token_row = mysqli_fetch_assoc($token_query);
$access_token = $token_row['access_token'];

/* =========================
   API CALL
========================= */

$url = $BASE_URL . "Payout/PayoutRemitterLogIn-withoutOtp";

$payload = json_encode([
    "RemitterMobile" => $mobile,
    "Token"          => $access_token,
    "RemiFName"      => $fname,
    "RemiLName"      => $lname
]);

$headers = [
    "ClientId: $CLIENT_ID",
    "ClientSecret: $CLIENT_SECRET",
    "ClientPass: $CLIENT_PASS",
    "ClientPin: $CLIENT_PIN",
    "ClientToken: $access_token",
    "Content-Type: application/json"
];

$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => $payload,
    CURLOPT_HTTPHEADER => $headers,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_SSL_VERIFYPEER => false
]);

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);

if(curl_errno($ch)){
    echo json_encode([
        "success"=>false,
        "message"=>"Curl Error: ".curl_error($ch)
    ]);
    curl_close($ch);
    exit();
}

curl_close($ch);

$result = json_decode($response, true);

/* =========================
   HANDLE RESPONSE
========================= */

if($http_code == 200 && isset($result['responseCode']) && $result['responseCode'] == 200){

    echo json_encode([
        "success"=>true,
        "message"=>"Remitter Logged In Successfully"
    ]);
    exit();

}else{

    $error_msg = $result['responseMessage'] ?? "Remitter login failed";

    echo json_encode([
        "success"=>false,
        "message"=>$error_msg
    ]);
    exit();
}