<?php
require_once '../../includes/auth.php';
include '../../db/db.php';

header('Content-Type: application/json');

if($_SESSION['role'] !== 'retailor'){
    echo json_encode(["success"=>false,"message"=>"Unauthorized"]);
    exit();
}

$action = $_POST['action'] ?? '';

$config = require '../../config/solitech_config.php';
$mode = $config['mode'];
$credentials = $config[$mode];

$base_url      = rtrim($credentials['base_url'],'/');
$client_id     = trim($credentials['client_id']);
$client_secret = trim($credentials['client_secret']);
$client_pass   = trim($credentials['client_pass']);
$client_pin    = trim($credentials['client_pin']);

$retailor_id = $_SESSION['user_id'];



/* =====================================================
   GENERATE TOKEN
===================================================== */
if($action === 'generate'){

    $url = $base_url . "/api/Token/GenerateToken";
    $raw_body = '"' . $client_id . '"';

    $headers = [
        "ClientId: $client_id",
        "ClientSecret: $client_secret",
        "ClientPass: $client_pass",
        "ClientPin: $client_pin",
        "Content-Type: application/json"
    ];

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $raw_body);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);

    $response = curl_exec($ch);

    if(curl_errno($ch)){
        echo json_encode(["success"=>false,"message"=>"Curl Error"]);
        exit();
    }

    curl_close($ch);

    $data = json_decode($response, true);

    if(!isset($data['responseCode']) || $data['responseCode'] != 200){
        echo json_encode(["success"=>false,"message"=>"API Token Generation Failed"]);
        exit();
    }

    $access_token = $data['data'];
    $expires_at   = date('Y-m-d H:i:s', strtotime('+55 minutes'));

    mysqli_query($conn,"DELETE FROM solitech_tokens WHERE user_id='$retailor_id'");

    mysqli_query($conn,"
        INSERT INTO solitech_tokens (user_id, access_token, expires_at)
        VALUES ('$retailor_id', '".mysqli_real_escape_string($conn,$access_token)."', '$expires_at')
    ");

    echo json_encode(["success"=>true,"message"=>"Token Generated Successfully"]);
    exit();
}



/* =====================================================
   VERIFY TOKEN
===================================================== */
if($action === 'verify'){

    $token_row = mysqli_fetch_assoc(mysqli_query($conn,"
        SELECT access_token FROM solitech_tokens
        WHERE user_id='$retailor_id'
        ORDER BY id DESC LIMIT 1
    "));

    if(!$token_row){
        echo json_encode(["success"=>false,"message"=>"No Token Found"]);
        exit();
    }

    $token = $token_row['access_token'];

    $url = $base_url . "/api/Token/VerifyToken";

    $headers = [
        "ClientId: $client_id",
        "ClientSecret: $client_secret",
        "ClientToken: $token",
        "Content-Type: application/json"
    ];

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);

    $response = curl_exec($ch);

    if(curl_errno($ch)){
        echo json_encode(["success"=>false,"message"=>"Curl Error"]);
        exit();
    }

    curl_close($ch);

    $data = json_decode($response, true);

    if(isset($data['responseCode']) && $data['responseCode'] == 200){
        echo json_encode(["success"=>true,"message"=>"Token Verified Successfully"]);
    }else{
        echo json_encode(["success"=>false,"message"=>"Token Verification Failed"]);
    }

    exit();
}

echo json_encode(["success"=>false,"message"=>"Invalid Action"]);
exit();