<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once $_SERVER['DOCUMENT_ROOT'] . '/includes/auth.php';
require_once $_SERVER['DOCUMENT_ROOT'] . '/db/db.php';

header('Content-Type: application/json');

$config = require $_SERVER['DOCUMENT_ROOT'] . '/config/solitech_config.php';
$mode = $config['mode'];
$cfg  = $config[$mode];

if($_SESSION['role'] !== 'retailor'){
    echo json_encode(["success"=>false,"message"=>"Unauthorized"]);
    exit();
}

$retailor_id = $_SESSION['user_id'];

if($_SERVER['REQUEST_METHOD'] !== 'POST'){
    echo json_encode(["success"=>false,"message"=>"Invalid request"]);
    exit();
}

$bene_api_id = trim($_POST['beneficiary_id'] ?? '');

if($bene_api_id == ''){
    echo json_encode(["success"=>false,"message"=>"Beneficiary ID required"]);
    exit();
}

/* =========================
   FETCH BENEFICIARY
========================= */
$bene_query = mysqli_query($conn,"
SELECT * FROM solitech_beneficiaries 
WHERE bene_api_id='".mysqli_real_escape_string($conn,$bene_api_id)."'
AND user_id='$retailor_id'
LIMIT 1
");

if(mysqli_num_rows($bene_query) == 0){
    echo json_encode(["success"=>false,"message"=>"Invalid beneficiary"]);
    exit();
}

$bene = mysqli_fetch_assoc($bene_query);

/* =========================
   GET TOKEN
========================= */
$token_query = mysqli_query($conn,"
SELECT access_token 
FROM solitech_tokens 
WHERE user_id='$retailor_id'
ORDER BY id DESC LIMIT 1
");

if(mysqli_num_rows($token_query) == 0){
    echo json_encode(["success"=>false,"message"=>"Generate token first"]);
    exit();
}

$token_row = mysqli_fetch_assoc($token_query);
$access_token = $token_row['access_token'];

/* =========================
   API CALL
========================= */

$url = rtrim($cfg['base_url'],'/') . "/api/Payout/PayoutVerifyBene";

$payload = json_encode([
    "RemitterNumber" => $bene['remitter_mobile'],
    "BeneAccount"    => $bene['bene_account'],
    "BeneIFSC"       => $bene['bene_ifsc'],
    "BankCode"       => $bene['bank_code']
]);

$headers = [
    "ClientId: ".$cfg['client_id'],
    "ClientSecret: ".$cfg['client_secret'],
    "ClientPass: ".$cfg['client_pass'],
    "ClientPin: ".$cfg['client_pin'],
    "ClientTPin: ".$cfg['client_tpin'],     // ✅ REQUIRED
    "ClientToken: ".$access_token,
    "Content-Type: application/json"
];

$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => $payload,
    CURLOPT_HTTPHEADER => $headers,
    CURLOPT_SSL_VERIFYPEER => false,
    CURLOPT_TIMEOUT => 30
]);

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);

if(curl_errno($ch)){
    echo json_encode([
        "success"=>false,
        "message"=>"Curl Error: ".curl_error($ch)
    ]);
    curl_close($ch);
    exit();
}

curl_close($ch);

$result = json_decode($response, true);

/* =========================
   SAVE RESULT
========================= */

if($http_code == 200 && 
   isset($result['responseCode']) && 
   $result['responseCode'] == 200){

    mysqli_query($conn,"
    UPDATE solitech_beneficiaries 
    SET verify_status='Success',
        verify_response='".mysqli_real_escape_string($conn,$response)."',
        last_verified_at=NOW()
    WHERE bene_api_id='".mysqli_real_escape_string($conn,$bene_api_id)."'
    ");

    echo json_encode([
        "success"=>true,
        "message"=>"Beneficiary Verified Successfully"
    ]);
    exit();

}else{

    mysqli_query($conn,"
    UPDATE solitech_beneficiaries 
    SET verify_status='Failed',
        verify_response='".mysqli_real_escape_string($conn,$response)."'
    WHERE bene_api_id='".mysqli_real_escape_string($conn,$bene_api_id)."'
    ");

    $msg = $result['responseMessage'] ?? "Verification failed";

    echo json_encode([
        "success"=>false,
        "message"=>$msg
    ]);
    exit();
}